︠73e82123-2dbc-4403-bcc7-6fcea05c8869s︠
f(x) = x^3 - x

f_prime(x) = diff( f(x), x)

def tangent_at_point( x_0 ):
    y_0 = f( x_0 )
    m = f_prime( x_0 )

    # because y - y_0 = m(x - x_0) we know that
    # y - y_0 = mx - m*x_0
    # y = mx + y_0 - m*x_0
    # therefore b = y_0 - m*x_0

    b = y_0 - m*x_0

    P1 = plot( f(x), -2, 2, color='blue', ymin=-6, ymax=6, gridlines='minor')
    P2 = plot( m*x + b, -2, 2, color='tan', ymin=-6, ymax=6)
    P3 = point( (x_0, y_0), color='red', size=50)

    P = P1+P2+P3

    P.show()

    print()
    print("x_0 = ", x_0)
    print("y_0 = f(x_0) = ", y_0)
    print("m = f'(x_0) = ", m)
    print("tangent line: y = (", m, ")*x + (", b, ")")

    return

tangent_at_point(0.5)
︡03c101b2-7ce6-4d4b-b02c-c4bc04b6d3ab︡{"file":{"filename":"/home/user/.sage/temp/project-be9b8e05-80a0-4880-a05f-8c4edd999276/557/tmp_ct2oeyqq.svg","show":true,"text":null,"uuid":"0d1bf73e-b50b-4068-b492-8382e30e3c7b"},"once":false}︡{"stdout":"\n"}︡{"stdout":"x_0 =  0.500000000000000\ny_0 = f(x_0) =  -0.375000000000000\nm = f'(x_0) =  -0.250000000000000\ntangent line: y = ( -0.250000000000000 )*x + ( -0.250000000000000 )\n"}︡{"done":true}
︠6b6e3b6e-96a7-4b3a-9d3a-39054d8f8878︠
tangent_at_point(1.5)
︡19d4cd08-b813-49fe-b01c-3a553fa7270b︡{"once":false,"file":{"show":true,"uuid":"fde73699-f070-45af-9491-23fdd892e347","filename":"/mnt/home/44fad1ee1960432ebf9e9ca1b28ef0e5/.sage/temp/compute18a/26053/tmp_BlTISB.png"}}︡{"stdout":"\n"}︡{"stdout":"x_0 =  1.50000000000000\ny_0 = f(x_0) =  1.87500000000000\nm = f'(x_0) =  5.75000000000000\ntangent line: y = ( 5.75000000000000 )*x + ( -6.75000000000000 )\n"}︡
︠279c7a78-24b7-4daa-b33f-f80b8dfbf3f8︠
tangent_at_point(-1.75)
︡ebe41ef4-39de-4d73-8f59-295655862afb︡{"once":false,"file":{"show":true,"uuid":"c641599f-ad2c-40e7-81de-0ec1213f3c0a","filename":"/mnt/home/44fad1ee1960432ebf9e9ca1b28ef0e5/.sage/temp/compute18a/26053/tmp_3GwttY.png"}}︡{"stdout":"\n"}︡{"stdout":"x_0 =  -1.75000000000000\ny_0 = f(x_0) =  -3.60937500000000\nm = f'(x_0) =  8.18750000000000\ntangent line: y = ( 8.18750000000000 )*x + ( 10.7187500000000 )\n"}︡
︠6cc4c74c-4282-467e-a71c-2ee181ad3dd6︠
︡a7fc269e-da48-43e8-b555-6e29d7a14c26︡
︠15306028-707a-4a01-8e79-e36574674aac︠
︡26d4f361-3fb2-46a1-92b0-bbe3a59d864a︡
︠bfdf6d68-bf7f-4562-8fcd-1f38227b6749︠









